
//------------------------------------------------------------------------------
// Lab. 03: Transform the given system having distinct eigen values into 
// controllable canonical and diagonal form. 
//------------------------------------------------------------------------------

//scilab-5.5.0
//Operating System : OS X 10.9.3

//Clean the environment
clc;
clear all;
//clf;

// State space model
A=[-3 1; 1 -3];
B=[1;2];
C=[2 3];
D=0;

sys=syslin('c',A,B,C,D)
mprintf('State space representation of the given system is')
disp(sys)


// Eigen values of system matrix
eig_val=spec(A)
mprintf('Eigen values of the system matrix are')
disp(eig_val)

// Controllable canonical form
[Ac, Bc T]=canon(A,B)
T=flipdim(T,2);
Ac=T\A*T;
Bc=T\B;
Cc=C*T;
Dc=D;
sysc=syslin('c',Ac,Bc,Cc,Dc)
mprintf('State space representation of the given system in Controllable canonical form is')
disp(sysc)

// Diagonal form
[Ad M]=bdiag(A);
Bd=M\B;
Cd=C*M;
Dd=D;
sysd=syslin('c',Ad,Bd,Cd,Dd)
mprintf('State space representation of the given system in Diagonal form is')
disp(sysd)
